#ifndef __CPascalString__
#define __CPascalString__

//	===========================================================================

#include "CCountedObject.hpp"

//	===========================================================================

using Exponent::Basics::CCountedObject;

//	===========================================================================

namespace Exponent
{
	namespace Basics
	{
		/**
		 * @class CPascalString CPascalString.hpp
		 * @brief Pascal style string
		 *
		 * Represents a string as a pascal style string with string[0] = sizeof the string
		 *
		 * @date 03/03/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CPascalString.hpp,v 1.3 2007/02/08 21:06:44 paul Exp $
		 */
		class CPascalString : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param string The c style string (NULL terminated) that you want to conver to a pascal style string
			 * @param size The maximum internal size of the string (MacOsX requires 256)
			 */
			CPascalString(const char *string = " ", const long size = 256);

			/**
			 * Destructor
			 */
			virtual ~CPascalString();

//	===========================================================================

			/**
			 * Set the string
			 * @param string The string that you want to store
			 * @param size The maximum internal size of the string (MacOsX requires 256)
			 */
			void setString(const char *string, const long size = 256);

			/**
			 * Get the string
			 * @retval char* A pointer to the internal string buffer
			 */
			char *getString() const;

			/**
			 * Get the string as an unsigned char *
			 * @retval const unsigned char* A Pointer to the string cast to unsigned char*
			 */
			const unsigned char *getUnsignedConstString() const;

//	===========================================================================

		protected:

//  ===========================================================================

			char *m_string;					/**< The string we are storing */
		};
	}
}
#endif	// End of CPascalString.hpp